<?php
$video_meta = get_post_meta( get_the_ID(), 'qodef_post_format_video_url', true );
?>

<article <?php post_class( 'qodef-blog-item qodef-e' ); ?>>
	<div class="qodef-e-inner">
		<?php if ( ! empty( $video_meta ) && has_post_thumbnail() ) { ?>
			<div class="qodef-e-media-video">
				<a itemprop="url" class="qodef-e-post-url" href="<?php the_permalink(); ?>">
					<?php
					// Include post image
					tobel_core_theme_template_part( 'blog', 'templates/parts/post-info/video-image' );
					?>
					<div class="qodef-e-icon-wrapper">
						<span class="qodef-e-icon-holder">
							<span class="qodef-e-icon-text">
								<?php echo esc_attr__( 'Play', 'tobel' ); ?>
							</span>
						</span>
					</div>
				</a>
			</div>
			<?php
		} else {
			// Video player settings
			$settings = apply_filters(
				'tobel_filter_video_post_format_settings',
				array(
					'width'  => 1100, // Aspect ration is 16:9
					'height' => round( 1100 * 9 / 16 ),
					'loop'   => true,
				)
			);

			$oembed = wp_oembed_get( $video_meta );
			if ( ! empty( $oembed ) ) {
				echo wp_oembed_get( $video_meta, $settings );
				?>
				<?php
			}
		}
		?>
		<div class="qodef-e-content">
			<div class="qodef-e-top-holder">
				<div class="qodef-e-info">
					<?php

					// Include post date info
					tobel_template_part( 'blog', 'templates/parts/post-info/date' );

					// Include post author info
					tobel_template_part( 'blog', 'templates/parts/post-info/author' );

					// Include post category info
					tobel_template_part( 'blog', 'templates/parts/post-info/categories' );

					?>
				</div>
			</div>
			<div class="qodef-e-text">
				<?php
				// Include post title
				tobel_template_part( 'blog', 'templates/parts/post-info/title', '', array( 'title_tag' => 'h2' ) );

				// Include post excerpt
				tobel_template_part( 'blog', 'templates/parts/post-info/excerpt' );

				// Hook to include additional content after blog single content
				do_action( 'tobel_action_after_blog_single_content' );
				?>
			</div>
			<div class="qodef-e-bottom-holder">
				<div class="qodef-e-left">
					<?php
					// Include post read more
					tobel_template_part( 'blog', 'templates/parts/post-info/read-more' );
					?>
				</div>
				<div class="qodef-e-right qodef-e-info">
				</div>
			</div>
		</div>
	</div>
</article>
