<?php

if ( ! function_exists( 'tobel_load_page_mobile_header' ) ) {
	/**
	 * Function which loads page template module
	 */
	function tobel_load_page_mobile_header() {
		// Include mobile header template
		echo apply_filters( 'tobel_filter_mobile_header_template', tobel_get_template_part( 'mobile-header', 'templates/mobile-header' ) ); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
	}

	add_action( 'tobel_action_page_header_template', 'tobel_load_page_mobile_header' );
}

if ( ! function_exists( 'tobel_register_mobile_navigation_menus' ) ) {
	/**
	 * Function which registers navigation menus
	 */
	function tobel_register_mobile_navigation_menus() {
		$navigation_menus = apply_filters( 'tobel_filter_register_mobile_navigation_menus', array( 'mobile-navigation' => esc_html__( 'Mobile Navigation', 'tobel' ) ) );

		if ( ! empty( $navigation_menus ) ) {
			register_nav_menus( $navigation_menus );
		}
	}

	add_action( 'tobel_action_after_include_modules', 'tobel_register_mobile_navigation_menus' );
}
