<?php

if ( ! function_exists( 'tobel_is_page_title_enabled' ) ) {
	/**
	 * Function that check is module enabled
	 */
	function tobel_is_page_title_enabled() {
		return apply_filters( 'tobel_filter_enable_page_title', true );
	}
}

if ( ! function_exists( 'tobel_load_page_title' ) ) {
	/**
	 * Function which loads page template module
	 */
	function tobel_load_page_title() {

		if ( tobel_is_page_title_enabled() ) {
			// Include title template
			echo apply_filters( 'tobel_filter_title_template', tobel_get_template_part( 'title', 'templates/title' ) ); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
		}
	}

	add_action( 'tobel_action_page_title_template', 'tobel_load_page_title' );
}

if ( ! function_exists( 'tobel_get_page_title_classes' ) ) {
	/**
	 * Function that return classes for page title area
	 *
	 * @return string
	 */
	function tobel_get_page_title_classes() {
		$classes = apply_filters( 'tobel_filter_page_title_classes', array() );

		return implode( ' ', $classes );
	}
}

if ( ! function_exists( 'tobel_get_page_title_text' ) ) {
	/**
	 * Function that returns current page title text
	 */
	function tobel_get_page_title_text() {
		$title = get_the_title( tobel_get_page_id() );

		if ( ( is_home() && is_front_page() ) || is_singular( 'post' ) ) {
			$title = get_option( 'blogname' );
		} elseif ( is_tag() ) {
			$title = single_term_title( '', false ) . esc_html__( ' Tag', 'tobel' );
		} elseif ( is_date() ) {
			$title = get_the_time( 'F Y' );
		} elseif ( is_author() ) {
			$title = esc_html__( 'Author: ', 'tobel' ) . get_the_author();
		} elseif ( is_category() ) {
			$title = single_cat_title( '', false );
		} elseif ( is_archive() ) {
			$title = esc_html__( 'Archive', 'tobel' );
		} elseif ( is_search() ) {
			$title = esc_html__( 'Search results for: ', 'tobel' ) . get_search_query();
		} elseif ( is_404() ) {
			$title = esc_html__( '404 - Page not found', 'tobel' );
		}

		return apply_filters( 'tobel_filter_page_title_text', $title );
	}
}

if ( ! function_exists( 'tobel_theme_breadcrumbs' ) ) {
	/**
	 * Function that renders breadcrumbs html
	 */
	function tobel_theme_breadcrumbs() {
		$page_id = tobel_get_page_id();

		// Breadcrumbs label
		$labels = apply_filters(
			'tobel_theme_filter_breadcrumbs_label',
			array(
				'home'        => esc_html__( 'Home', 'tobel' ),
				'tag'         => esc_html__( 'Posts tagged "%s"', 'tobel' ),
				'author'      => esc_html__( 'Posted by %s', 'tobel' ),
				'search'      => esc_html__( 'Search results for "%s"', 'tobel' ),
				'404'         => esc_html__( '404 - Page not found', 'tobel' ),
				'query_paged' => esc_html__( '(Page %s)', 'tobel' ),
			)
		);

		// Breadcrumbs variables
		$settings = apply_filters(
			'tobel_theme_filter_breadcrumbs_settings',
			array(
				'wrap_before'  => '<div itemprop="breadcrumb" class="qodef-breadcrumbs">',
				'wrap_after'   => '</div>',
				'home_url'     => esc_url( home_url( '/' ) ),
				'link'         => '<a itemprop="url" class="qodef-breadcrumbs-link" href="%1$s"><span itemprop="title">' . '%2$s' . '</span></a>',
				'current_item' => '<span itemprop="title" class="qodef-breadcrumbs-current">' . '%1$s' . '</span>',
				'separator'    => '<span class="qodef-breadcrumbs-separator"></span>',
			)
		);

		$wrap_child = '';
		if ( is_home() && ! is_front_page() ) {
			$wrap = sprintf( $settings['link'], $settings['home_url'], $labels['home'] ) . $settings['separator'] . sprintf( $settings['current_item'], get_the_title( $page_id ) );

		} elseif ( is_home() || is_front_page() ) {
			$wrap = sprintf( $labels['home'] );

		} else {
			$wrap = sprintf( $settings['link'], $settings['home_url'], $labels['home'] ) . $settings['separator'];

			if ( is_tag() ) {
				$wrap_child .= sprintf( $settings['current_item'], sprintf( $labels['tag'], single_tag_title( '', false ) ) );

			} elseif ( is_day() ) {
				$wrap_child .= sprintf( $settings['link'], get_year_link( get_the_time( 'Y' ) ), get_the_time( 'Y' ) ) . $settings['separator'];
				$wrap_child .= sprintf( $settings['link'], get_month_link( get_the_time( 'Y' ), get_the_time( 'm' ) ), get_the_time( 'F' ) ) . $settings['separator'];
				$wrap_child .= sprintf( $settings['current_item'], get_the_time( 'd' ) );

			} elseif ( is_month() ) {
				$wrap_child .= sprintf( $settings['link'], get_year_link( get_the_time( 'Y' ) ), get_the_time( 'Y' ) ) . $settings['separator'];
				$wrap_child .= sprintf( $settings['current_item'], get_the_time( 'F' ) );

			} elseif ( is_year() ) {
				$wrap_child .= sprintf( $settings['current_item'], get_the_time( 'Y' ) );

			} elseif ( is_author() ) {
				$wrap_child .= sprintf( $settings['current_item'], sprintf( $labels['author'], get_the_author_meta( 'display_name', get_query_var( 'author' ) ) ) );

			} elseif ( is_category() ) {
				$category = get_category( get_query_var( 'cat' ), false );

				if ( isset( $category->parent ) && 0 !== $category->parent ) {
					$wrap_child .= get_category_parents( $category->parent, true, $settings['separator'] );
				}

				$wrap_child .= sprintf( $settings['current_item'], single_cat_title( '', false ) );

			} elseif ( is_search() ) {
				$wrap_child .= sprintf( $settings['current_item'], sprintf( $labels['search'], get_search_query() ) );

			} elseif ( is_404() ) {
				$wrap_child .= sprintf( $settings['current_item'], $labels['404'] );

			} elseif ( is_single() ) {
				if ( is_singular( 'post' ) ) {
					$category   = get_the_category();
					$wrap_child .= get_category_parents( $category[0], true, $settings['separator'] );
				}

				$wrap_child .= sprintf( $settings['current_item'], get_the_title() );

			} elseif ( is_page() ) {
				global $post;

				if ( $post->post_parent ) {
					$parent_ids   = array();
					$parent_ids[] = $post->post_parent;

					foreach ( $parent_ids as $parent_id ) {
						$wrap_child .= sprintf( $settings['link'], get_the_permalink( $parent_id ), get_the_title( $parent_id ) ) . $settings['separator'];
					}
				}

				$wrap_child .= sprintf( $settings['current_item'], get_the_title() );
			}

			if ( get_query_var( 'paged' ) ) {
				$wrap_child .= sprintf( $settings['current_item'], sprintf( $labels['query_paged'], get_query_var( 'paged' ) ) );
			}
		}

		// Breadcrumbs html template
		$breadcrumbs_html = '';
		if ( ! empty( $wrap ) ) {
			$breadcrumbs_html = $settings['wrap_before'] . $wrap . apply_filters( 'tobel_theme_filter_breadcrumbs_content', $wrap_child, $settings ) . $settings['wrap_after'];
		}

		echo apply_filters( 'tobel_theme_filter_breadcrumbs_template', $breadcrumbs_html );
	}
}
